#ifdef CG_PS3
	#define _VS_POSITION 		ATTR0
	#define _VS_NORMAL 			ATTR1
	#define _VS_COLOR 			ATTR2
	#define _VS_TEXCOORD0 		ATTR5
	#define _VS_BLENDWEIGHT 	ATTR10
	#define _VS_BLENDINDICES 	ATTR9

	#define	_PS_POSITION		POSITION
	#define _PS_COLOR			COLOR
	#define _PS_TEXCOORD0		TEXCOORD0
	#define _PS_TEXCOORD1		TEXCOORD1

#else

	#define _VS_POSITION 		POSITION
	#define _VS_NORMAL 			NORMAL
	#define _VS_COLOR 			COLOR
	#define _VS_TEXCOORD0 		TEXCOORD0
	#define _VS_BLENDWEIGHT 	BLENDWEIGHT
	#define _VS_BLENDINDICES 	BLENDINDICES

	#define	_PS_POSITION		POSITION
	#define _PS_COLOR			COLOR
	#ifdef SM1
		#define _PS_TEXCOORD0		TEXCOORD0
		#define _PS_TEXCOORD1		TEXCOORD1
	#else
		#define _PS_TEXCOORD0		TEXCOORD0_centroid
		#define _PS_TEXCOORD1		TEXCOORD1_centroid
	#endif
#endif

//--------------------------------------------------------------------------------------

#include "VertexShaderSemantics.fx"
#include "FragmentShaderSemantics.fx"
#include "hdr.hlsl"

#define g_View				vs_view
#define g_FrustumParams		vs_frustum_params
#define g_ProjectionParams	vs_projection_params
#define g_ViewportScaleBias	vs_viewportScaleBias
#define g_uvOffset01		uvOffset01

sampler2D layer0_sampler : register(s0);

#define stencil_tex layer0_sampler

uniform float4x4 projection		: register(c128);
uniform float4 planeEq			: register(c132);

#ifdef SM1
uniform float4 uniformColor		: register(c0);
#elif defined(SM2)
uniform float4 uniformColor		: register(c31);
#else
uniform float4 uniformColor		: register(c133);
#endif


//--------------------------------------------------------------------------------------

struct VS_IN_POS
{
	float4 position			: _VS_POSITION;
};

struct VS_IN_POS_UVSET0
{
	float4 position			: _VS_POSITION;
	float2 uvSet0			: _VS_TEXCOORD0;
};

struct VS_IN_POS_UVSET0F4
{
	float4 position			: _VS_POSITION;	
	float4 uvSet0			: _VS_TEXCOORD0;	
};

struct VS_IN_POS_SKIN
{
	float4 position			: _VS_POSITION;
	float4 blendWeight0		: _VS_BLENDWEIGHT;
	float4 blendIndices0	: _VS_BLENDINDICES;
};

struct VS_IN_POS_UVSET0_SKIN
{
	float4 position			: _VS_POSITION;
	float2 uvSet0			: _VS_TEXCOORD0;
	float4 blendWeight0		: _VS_BLENDWEIGHT;
	float4 blendIndices0	: _VS_BLENDINDICES;
};

struct VS_IN_POS_UVSET0_CLR_NRM_SKIN
{
	float4 position			: _VS_POSITION;
	float2 uvSet0			: _VS_TEXCOORD0;
	float4 colorSet0		: _VS_COLOR;
	float4 normal			: _VS_NORMAL;
	float4 blendWeight0		: _VS_BLENDWEIGHT;
	float4 blendIndices0	: _VS_BLENDINDICES;
};

struct VS_IN_POS_CLR_NRM
{
	float4 position			: _VS_POSITION;
	float4 colorSet0		: _VS_COLOR;
	float4 normal			: _VS_NORMAL;
};

struct VS_IN_POS_UVSET0_CLR_NRM
{
	float4 position			: _VS_POSITION;
	float2 uvSet0			: _VS_TEXCOORD0;
	float4 colorSet0		: _VS_COLOR;
	float4 normal			: _VS_NORMAL;
};

#if defined(WATERDISTORTION)
	#define VS_IN_2D VS_IN_POS_UVSET0F4
#else
	#ifdef _WINPC
		#define VS_IN_2D VS_IN_POS_UVSET0
	#else		
		#define VS_IN_2D VS_IN_POS
	#endif
#endif

//--------------------------------------------------------------------------------------

struct VS_OUT_POS
{
	float4 position		: _PS_POSITION;
#if defined(DEPTH_AS_COLOR)
	float4 position2	: _PS_TEXCOORD0;
#endif
};

struct VS_OUT_POS_UVSET01
{
	float4 position		: _PS_POSITION;
	float4 uvSet01		: _PS_TEXCOORD0;
#if defined(DEPTH_AS_COLOR)
	float4 position2	: _PS_TEXCOORD1;
#endif
};

struct VS_OUT_POS_CLR
{
	float4 position : _PS_POSITION;
	float4 colorSet0 : _PS_COLOR;
};

struct VS_OUT_POS_UVSET01_CLR
{
	float4 position : _PS_POSITION;
	float4 uvSet01 : _PS_TEXCOORD0;
	float4 colorSet0 : _PS_COLOR;

#if defined(DEPTH_AS_COLOR)
	float4 position2	: _PS_TEXCOORD1;
#endif
};

//--------------------------------------------------------------------------------------

half4 computeVertexSkin3( const in float4 pos,
						  const in float4x4 skinMatrix0,
						  const in float4x4 skinMatrix1,
						  const in float4x4 skinMatrix2,
						  const in half w0, const in half w1, const in half w2 )
{
	float4 t0 = mul(pos, skinMatrix0);
	float4 t1 = mul(pos, skinMatrix1);
	float4 t2 = mul(pos, skinMatrix2);
	return t0*w0 + t1*w1 + t2*w2;
}

//--------------------------------------------------------------------------------------

half4 computeVertexSkin4( const in float4 pos,
                          const in float4x4 skinMatrix0,
                          const in float4x4 skinMatrix1,
                          const in float4x4 skinMatrix2,
                          const in float4x4 skinMatrix3,
                          const in half4 weights )
{
    float4 t0 = mul(pos, skinMatrix0);
    float4 t1 = mul(pos, skinMatrix1);
    float4 t2 = mul(pos, skinMatrix2);
	float4 t3 = mul(pos, skinMatrix3);
    return t0 * weights.x + t1 * weights.y + t2 * weights.z + t3 * weights.w;
}

//--------------------------------------------------------------------------------------

float4 transformWorldViewProj( const in float4 pos )
{
#ifdef _360_TARGET
	// This is needed to make the assembly code match that of ubershader
	[isolate]
#endif
	float4 posH = mul( pos, world );
	return mul( posH, viewProj );
}

//--------------------------------------------------------------------------------------

// output pos/tex0
VS_OUT_POS_UVSET01_CLR default_2d_vx( VS_IN_2D input )
{ 
	VS_OUT_POS_UVSET01_CLR output;
	output.position = input.position; // we need the W too!
#ifdef _WINPC
	output.uvSet01.zw = input.uvSet0;
#else
	output.uvSet01.zw = input.position.xy * half2(0.5, -0.5) + 0.5;
#endif
	output.uvSet01.xy = output.uvSet01.zw * g_ViewportScaleBias.zw + g_ViewportScaleBias.xy;
	output.colorSet0 = float4(1.0,1.0,1.0,1.0);
	return output;
}

// output pos/tex0
VS_OUT_POS_UVSET01_CLR default_2d_tex0_vx( VS_IN_POS_UVSET0_CLR_NRM input )
{
	VS_OUT_POS_UVSET01_CLR output;

	output.position	= input.position;
	output.uvSet01	= float4( input.uvSet0 + g_uvOffset01.xy, 0.0, 1.0 );	
	output.colorSet0= float4(input.colorSet0.rgb * 2, input.normal.a);

	return output;
}

// output pos
VS_OUT_POS default_3d_vx( VS_IN_POS input )
{
	VS_OUT_POS output;
	output.position = transformWorldViewProj( float4(input.position.xyz, 1.0) );

#if defined(DEPTH_AS_COLOR)
	output.position2 = output.position;
#endif

	return output;
}

// output skinned pos
VS_OUT_POS default_3d_skin3_vx( VS_IN_POS_SKIN input )
{
	VS_OUT_POS output;

	half4 blendIndices0 = input.blendIndices0;
	half4 blendWeight0 = input.blendWeight0;

	float4 skinposition = computeVertexSkin3(
		float4(input.position.xyz, 1.0),
        skinMatrix[int(blendIndices0.x)],
        skinMatrix[int(blendIndices0.y)],
        skinMatrix[int(blendIndices0.z)],
       blendWeight0.x, blendWeight0.y, 1.0 - blendWeight0.x - blendWeight0.y );

	output.position = transformWorldViewProj( skinposition );

#if defined(DEPTH_AS_COLOR)
	output.position2 = output.position;
#endif

	return output;
}

// output skinned pos
VS_OUT_POS default_3d_skin4_vx( VS_IN_POS_SKIN input )
{
	VS_OUT_POS output;

	half4 blendIndices0 = input.blendIndices0;
	half4 blendWeight0 = input.blendWeight0;

	float4 skinposition = computeVertexSkin4(
		float4(input.position.xyz, 1.0),
        skinMatrix[int(blendIndices0.x)],
        skinMatrix[int(blendIndices0.y)],
        skinMatrix[int(blendIndices0.z)],
        skinMatrix[int(blendIndices0.w)],
        blendWeight0 );

	output.position = transformWorldViewProj( skinposition );

#if defined(DEPTH_AS_COLOR)
	output.position2 = output.position;
#endif

	return output;
}

// output pos/tex0
VS_OUT_POS_UVSET01_CLR default_3d_tex0_vx( VS_IN_POS_UVSET0_CLR_NRM input )
{
	VS_OUT_POS_UVSET01_CLR output;

	output.position	= transformWorldViewProj( float4(input.position.xyz, 1.0) );
	output.uvSet01	= float4( input.uvSet0 + g_uvOffset01.xy, 0.0, 1.0 );	
	output.colorSet0= float4(input.colorSet0.rgb * 2, input.normal.a);

#if defined(DEPTH_AS_COLOR)
	output.position2 = output.position;
#endif

	return output;
}

// output skinned pos/tex0
VS_OUT_POS_UVSET01_CLR default_3d_skin3_tex0_vx( VS_IN_POS_UVSET0_CLR_NRM_SKIN input )
{
	VS_OUT_POS_UVSET01_CLR output;

	half4 blendIndices0 = input.blendIndices0;
	half4 blendWeight0 = input.blendWeight0;

	float4 skinposition = computeVertexSkin3(
		float4(input.position.xyz, 1.0),
        skinMatrix[int(blendIndices0.x)],
        skinMatrix[int(blendIndices0.y)],
        skinMatrix[int(blendIndices0.z)],
        blendWeight0.x, blendWeight0.y, 1.0 - blendWeight0.x - blendWeight0.y );

	output.position		= transformWorldViewProj( skinposition );
	output.uvSet01		= float4( input.uvSet0 + g_uvOffset01.xy, 0.0, 1.0 );	
	output.colorSet0	= float4(input.colorSet0.rgb * 2, input.normal.a);

#if defined(DEPTH_AS_COLOR)
	output.position2 = output.position;
#endif

	return output;
}

// output skinned pos/tex0
VS_OUT_POS_UVSET01_CLR default_3d_skin4_tex0_vx( VS_IN_POS_UVSET0_CLR_NRM_SKIN input )
{
	VS_OUT_POS_UVSET01_CLR output;

	half4 blendIndices0 = input.blendIndices0;
	half4 blendWeight0 = input.blendWeight0;

	float4 skinposition = computeVertexSkin4(
		float4(input.position.xyz, 1.0),
        skinMatrix[int(blendIndices0.x)],
        skinMatrix[int(blendIndices0.y)],
        skinMatrix[int(blendIndices0.z)],
        skinMatrix[int(blendIndices0.w)],
        blendWeight0 );

	output.position		= transformWorldViewProj( skinposition );
	output.uvSet01		= float4( input.uvSet0 + g_uvOffset01.xy, 0.0, 1.0 );	
	output.colorSet0	= float4(input.colorSet0.rgb * 2, input.normal.a);

#if defined(DEPTH_AS_COLOR)
	output.position2 = output.position;
#endif

	return output;
}

// output uniform colour
float4 default_px( ) : COLOR
{
	return uniformColor;
}

// output black
float4 default_null_px( ) : COLOR
{
	return float4( 0.0, 0.0, 0.0, 1.0 );
}

// output lookup into sampler 0.
float4 default_tex0_px( VS_OUT_POS_UVSET01_CLR input ) : COLOR
{
	return tex2D( layer0_sampler, input.uvSet01 ) * input.colorSet0;
}

float3 float2RGB(float f)
{
	float iFloat = f * 0xFFFFFF;

	float high;
	iFloat = modf(iFloat / (256.0 * 256.0), high);
	iFloat *= 256.0 * 256.0;
	high /= 0xFF;

	float med;
	iFloat = modf(iFloat / 256.0, med);
	med /= 0xFF;

	float3 result = 0;
	result.r = high;
	result.g = med;
	result.b = iFloat;

	return result;
}

#if defined(DEPTH_AS_COLOR)

// output depth as color
float4 depthAsColor_px( VS_OUT_POS input ) : COLOR
{
	float3 depthRGB = float2RGB(input.position2.z / input.position2.w);

	return float4(depthRGB, 1);
}

// output lookup into sampler 0.
float4 depthAsColor_tex0_px( VS_OUT_POS_UVSET01_CLR input ) : COLOR
{
	float3 depthRGB = float2RGB(input.position2.z / input.position2.w);

	return float4(depthRGB, tex2D( layer0_sampler, input.uvSet01 ).a * input.colorSet0.a);
}

#endif // DEPTH_AS_COLOR

//--------------------------------------------------------------------------------------

VS_OUT_POS_CLR nuprim_2d_clr_vx( VS_IN_POS_CLR_NRM input )
{
	VS_OUT_POS_CLR output;
	output.position = input.position;
	output.colorSet0 = float4( input.colorSet0.rgb, input.normal.a );
	return output;
}

VS_OUT_POS_UVSET01_CLR nuprim_2d_tex0_clr_vx( VS_IN_POS_UVSET0_CLR_NRM input )
{
	VS_OUT_POS_UVSET01_CLR output;
	output.position = input.position;
	output.uvSet01 = float4( input.uvSet0, 0.0, 0.0 );	
	output.colorSet0 = float4( input.colorSet0.rgb, input.normal.a );
	return output;
}

VS_OUT_POS_CLR nuprim_3d_clr_vx( VS_IN_POS_CLR_NRM input )
{
	VS_OUT_POS_CLR output;
	output.position = transformWorldViewProj( float4(input.position.xyz, 1.0) );
	output.colorSet0 = float4( input.colorSet0.rgb, input.normal.a );
	return output;
}

VS_OUT_POS_UVSET01_CLR nuprim_3d_tex0_clr_vx( VS_IN_POS_UVSET0_CLR_NRM input )
{
	VS_OUT_POS_UVSET01_CLR output;
	output.position = transformWorldViewProj( float4(input.position.xyz, 1.0) );
	output.uvSet01 = float4( input.uvSet0, 0.0, 0.0 );	
	output.colorSet0 = float4( input.colorSet0.rgb, input.normal.a );
	return output;
}

float4 nuprim_clr_px( VS_OUT_POS_CLR input ) : COLOR
{
	float4 t0 = input.colorSet0 * float4(2,2,2,1);
	float4 t1 = float4( HDRToLDR(t0, false).rgb, t0.a );
	return t1;
}

float4 nuprim_tex0_clr_px( VS_OUT_POS_UVSET01_CLR input ) : COLOR
{
	float4 t0 = tex2D( layer0_sampler, input.uvSet01.xy ) * input.colorSet0 * float4(2,2,2,1);
	float4 t1 = float4( HDRToLDR(t0, false).rgb, t0.a );
	return t1;
}

//--------------------------------------------------------------------------------------

half4 decompose_stencil_px( VS_OUT_POS_UVSET01_CLR input ) : COLOR
{
	half4 output = 0;
	half stencil = tex2D(stencil_tex, input.uvSet01.xy).b;

	// Don't receive shadow
	{
		output.r = stencil >= (127.999 / 255.0);
		stencil -= 128.0 / 255.0 * output.r;
	}

	// Don't self shadow
	{
		output.g = stencil >= (63.999 / 255.0);
		stencil -= 64.0 / 255.0 * output.g;
	}

	// Specular power
	{
		output.a =	stencil	* 255.0 / 63.0;
	}

	return output;
}
